

************************************************************
************************************************************
***          Marriage and Happiness                      ***
***   1: Retrieving the data from the SOEP               ***
***		    Josef Brderl, Volker Ludwig           	     *** 	   
***		            March 2011                           *** 	   
************************************************************
************************************************************

* Data: SOEP 1984-2009 v26

* The goal is to estimate the causal effect of (first) marriage by comparison of 
* changes in life satisfaction (happiness) before and after marriage

* "All things considered, how satisfied are you currently with your life?"
* Answers are recorded on an eleven-point scale 
* (0=extremely dissatisfied 10=extremely satisfied)

* The final data set should contain repeated measures on the following variables: 
* ID, year, life satisfaction, marriage, years married, 
* household income, age, sex


*************************************
** Preliminaries    *****************
*************************************

* Set system memory and define working directories
clear 
set more off
set mem 300m
version 11

*  Directories
global pfad1 `""C:\SOEP\V26\""'        //directory of original data 
global pfad2 `""C:\SOEP\work\""'       //working directory


***************************************************************
*** 1. STEP: PULL HAPPINESS FROM $P                     *******
***************************************************************

local year=1984                        //preparing $P and saving these files
foreach wave in a b c d e f g h i j k l m n o p q r s t u v w x y z{
	cd $pfad1
	use `wave'p.dta, clear
	ren persnr id                      //our person identifier is "id"
	gen year=`year'                    //this is our wave identifier
	foreach var in ap6801 bp9301 cp9601 dp9801 ep89 fp108 gp109 hp10901 ip10901   ///
	            jp10901 kp10401 lp10401 mp11001 np11701 op12301 pp13501 qp14301   ///
			  rp13501 sp13501 tp14201 up14501 vp154 wp142 xp149 yp15501 zp15701 {
		capture rename `var' happy     //rename to happy, do not stop if error
	}
	keep id year happy 
	cd $pfad2
	save `wave'work.dta, replace       //save the prepared files
	local year=`year'+1
}

*****************************************************************
* Unfortunately some person-years are not in $P, but in special data sets
* With happiness this is the case with GPOST and $PAGE17
cd $pfad1
use gpost.dta, clear     //GPOST (East 1990) needs special treatment
ren persnr id 
gen year=1990 
rename gp6401e happy     //rename to happy 	
keep id year happy 
cd $pfad2
save gework.dta, replace

local year=2006                        //preparing $PAGE17 and saving these files
foreach wave in w x y z{
	cd $pfad1
	use `wave'page17.dta, clear
	ren persnr id                      //our person identifier is "id"
	gen year=`year'                    //this is our wave identifier
 	foreach var in wj98 xj99 yj99 zj99 {
		capture rename `var' happy     //rename to happy, do not stop if error
	}
	keep id year happy
	cd $pfad2
	save `wave'ywork.dta, replace      //save the prepared files
	local year=`year'+1
}
*******************************************************************

use awork.dta, clear                //pool all years
foreach wave in b c d e f g h i j k l m n o p q r s t u v w x y z{
	append using `wave'work.dta
}
capture append using gework.dta            //match East 1990
capture append using wywork.dta            //match youth 2006
capture append using xywork.dta            //match youth 2007
capture append using yywork.dta            //match youth 2008
capture append using zywork.dta            //match youth 2009

save master.dta, replace 


***************************************************************
*** 2. STEP: MERGE INFO FROM $PEQUIV                    *******
***************************************************************
* $PEQUIV meanwhile include happiness. But unfortunately not for the
* person-years in $PAGE17. Therefore, we pulled happiness from $P.

local year=1984          //preparing $PEQUIV and saving these files
foreach wave in a b c d e f g h i j k l m n o p q r s t u v w x y z{
	cd $pfad1
	use `wave'pequiv.dta, clear
	ren persnr id            //our person identifier is "id"
	gen year=`year'          //this is our wave identifier
	ren i11102 hhinc         //hhinc
    ren d11101 age           //age
	ren d11102 sex           //sex
	ren d11104 marstat       //marital status
	keep id year hhinc age sex marstat
	cd $pfad2
	save `wave'work.dta, replace    //save the prepared files
	local year=`year'+1
}
use awork.dta, clear                //pool all years
foreach wave in b c d e f g h i j k l m n o p q r s t u v w x y z{
	append using `wave'work.dta
}

merge 1:1 id year using master.dta
drop if _merge==1
drop _merge


***************************************************************
*** 3. STEP: SAVE FINAL DATA SET                        *******
***************************************************************

sort  id year
order id year sex age marstat happy hhinc
compress
save Happiness1.dta, replace 

* Delete auxiliary files
foreach wave in a b c d e f g ge h i j k l m n o p q r s t u v w wy x xy y yy z zy{
	capture erase `wave'work.dta
}
erase master.dta


